/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityCyclops;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_4739;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;

public class CyclopsCaveStructure
extends class_3195 {
    public static final Codec<CyclopsCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CyclopsCaveStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, CyclopsCaveStructure::new)).codec();

    protected CyclopsCaveStructure(class_3195.class_7302 config) {
        super(config);
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (context.comp_566().method_43058() >= (Double)IafCommonConfig.INSTANCE.worldGen.generateCyclopsCaveChance.getValue()) {
            return Optional.empty();
        }
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos = this.method_42382(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(blockPos, collector -> collector.method_35462((class_3443)new CyclopsCavePiece(0, new class_3341(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())))));
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.CYCLOPS_CAVE.get();
    }

    public static class CyclopsCavePiece
    extends class_3443 {
        public static final class_2960 CYCLOPS_CHEST = class_2960.method_43902((String)"iceandfire", (String)"chest/cyclops_cave");

        protected CyclopsCavePiece(int length, class_3341 boundingBox) {
            super((class_3773)IafStructurePieces.CYCLOPS_CAVE.get(), length, boundingBox);
        }

        public CyclopsCavePiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.CYCLOPS_CAVE.get(), nbt);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int size = 16;
            CyclopsCavePiece.generateShell(world, pivot, random, size);
            int innerSize = size - 2;
            int x = innerSize + random.method_43048(2);
            int y = 10 + random.method_43048(2);
            int z = innerSize + random.method_43048(2);
            float radius = (float)(x + y + z) * 0.333f + 0.5f;
            int sheepPenCount = 0;
            for (class_2338 position : class_2338.method_20437((class_2338)pivot.method_10069(-x, -y, -z), (class_2338)pivot.method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(position.method_10262((class_2382)pivot) <= (double)(radius * radius)) || position.method_10264() <= pivot.method_10264() || world.method_8320(pivot).method_26204() instanceof class_4739) continue;
                world.method_8652(position, class_2246.field_10124.method_9564(), 3);
            }
            for (class_2338 position : class_2338.method_20437((class_2338)pivot.method_10069(-x, -y, -z), (class_2338)pivot.method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                if (!(position.method_10262((class_2382)pivot) <= (double)(radius * radius)) || position.method_10264() != pivot.method_10264()) continue;
                if (random.method_43048(130) == 0 && this.isTouchingAir((class_1936)world, position.method_10084())) {
                    this.generateSkeleton((class_1936)world, position.method_10084(), random, pivot, radius);
                }
                if (random.method_43048(130) == 0 && position.method_10262((class_2382)pivot) <= (double)(radius * radius) * (double)0.8f && sheepPenCount < 2) {
                    this.generateSheepPen((class_5425)world, position.method_10084(), random, pivot, radius);
                    ++sheepPenCount;
                }
                if (random.method_43048(80) == 0 && this.isTouchingAir((class_1936)world, position.method_10084())) {
                    class_2586 blockEntity;
                    world.method_8652(position.method_10084(), (class_2680)((class_2248)IafBlocks.GOLD_PILE.get()).method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                    world.method_8652(position.method_10084().method_10095(), (class_2680)((class_2248)IafBlocks.GOLD_PILE.get()).method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                    world.method_8652(position.method_10084().method_10072(), (class_2680)((class_2248)IafBlocks.GOLD_PILE.get()).method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                    world.method_8652(position.method_10084().method_10067(), (class_2680)((class_2248)IafBlocks.GOLD_PILE.get()).method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                    world.method_8652(position.method_10084().method_10078(), (class_2680)((class_2248)IafBlocks.GOLD_PILE.get()).method_9564().method_11657((class_2769)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                    world.method_8652(position.method_10086(2), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)GenerationConstants.HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (world.method_8320(position.method_10086(2)).method_26204() instanceof class_4739 && (blockEntity = world.method_8321(position.method_10086(2))) instanceof class_2595) {
                        class_2595 chestBlockEntity = (class_2595)blockEntity;
                        chestBlockEntity.method_11285(CYCLOPS_CHEST, random.method_43055());
                    }
                }
                if (random.method_43048(50) != 0 || !this.isTouchingAir((class_1936)world, position.method_10084())) continue;
                int torchHeight = random.method_43048(2) + 1;
                for (int fence = 0; fence < torchHeight; ++fence) {
                    world.method_8652(position.method_10086(1 + fence), this.getFenceState((class_1936)world, position.method_10086(1 + fence)), 3);
                }
                world.method_8652(position.method_10086(1 + torchHeight), class_2246.field_10336.method_9564(), 2);
            }
            EntityCyclops cyclops = (EntityCyclops)((class_1299)IafEntities.CYCLOPS.get()).method_5883((class_1937)world.method_8410());
            if (cyclops != null) {
                cyclops.method_5641((double)pivot.method_10263() + 0.5, (double)pivot.method_10264() + 1.5, (double)pivot.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
                world.method_8649((class_1297)cyclops);
            }
        }

        private void generateSheepPen(class_5425 level, class_2338 position, class_5819 random, class_2338 origin, float radius) {
            class_2338 relativePosition;
            int side;
            int sideCount;
            int width = 5 + random.method_43048(3);
            int sheepAmount = 2 + random.method_43048(3);
            class_2350 direction = class_2350.field_11043;
            class_2338 end = position;
            for (sideCount = 0; sideCount < 4; ++sideCount) {
                for (side = 0; side < width; ++side) {
                    relativePosition = end.method_10079(direction, side);
                    if (!(origin.method_10262((class_2382)relativePosition) <= (double)(radius * radius))) continue;
                    level.method_8652(relativePosition, this.getFenceState((class_1936)level, relativePosition), 3);
                    if (!level.method_22347(relativePosition.method_10093(direction.method_10170())) || sheepAmount <= 0) continue;
                    class_2338 sheepPos = relativePosition.method_10093(direction.method_10170());
                    class_1472 sheep = new class_1472(class_1299.field_6115, (class_1937)level.method_8410());
                    sheep.method_5814((double)((float)sheepPos.method_10263() + 0.5f), (double)((float)sheepPos.method_10264() + 0.5f), (double)((float)sheepPos.method_10260() + 0.5f));
                    sheep.method_6631(random.method_43048(4) == 0 ? class_1767.field_7947 : class_1767.field_7952);
                    level.method_8649((class_1297)sheep);
                    --sheepAmount;
                }
                end = end.method_10079(direction, width);
                direction = direction.method_10170();
            }
            for (sideCount = 0; sideCount < 4; ++sideCount) {
                for (side = 0; side < width; ++side) {
                    relativePosition = end.method_10079(direction, side);
                    if (!(origin.method_10262((class_2382)relativePosition) <= (double)(radius * radius))) continue;
                    level.method_8652(relativePosition, this.getFenceState((class_1936)level, relativePosition), 3);
                }
                end = end.method_10079(direction, width);
                direction = direction.method_10170();
            }
        }

        private void generateSkeleton(class_1936 level, class_2338 position, class_5819 random, class_2338 origin, float radius) {
            class_2350 direction = GenerationConstants.HORIZONTALS[random.method_43048(3)];
            class_2350.class_2351 oppositeAxis = direction.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
            int maxRibHeight = random.method_43048(2);
            for (int spine = 0; spine < 5 + random.method_43048(2) * 2; ++spine) {
                class_2338 segment = position.method_10079(direction, spine);
                if (origin.method_10262((class_2382)segment) <= (double)(radius * radius)) {
                    level.method_8652(segment, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()), 2);
                }
                if (spine % 2 == 0) continue;
                class_2338 rightRib = segment.method_10093(direction.method_10160());
                class_2338 leftRib = segment.method_10093(direction.method_10170());
                if (origin.method_10262((class_2382)rightRib) <= (double)(radius * radius)) {
                    level.method_8652(rightRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                if (origin.method_10262((class_2382)leftRib) <= (double)(radius * radius)) {
                    level.method_8652(leftRib, (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.method_10262((class_2382)rightRib.method_10086(ribHeight).method_10093(direction.method_10160())) <= (double)(radius * radius)) {
                        level.method_8652(rightRib.method_10086(ribHeight).method_10093(direction.method_10160()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                    }
                    if (!(origin.method_10262((class_2382)leftRib.method_10086(ribHeight).method_10093(direction.method_10170())) <= (double)(radius * radius))) continue;
                    level.method_8652(leftRib.method_10086(ribHeight).method_10093(direction.method_10170()), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 2);
                }
                if (origin.method_10262((class_2382)rightRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    level.method_8652(rightRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
                }
                if (!(origin.method_10262((class_2382)leftRib.method_10086(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                level.method_8652(leftRib.method_10086(maxRibHeight + 2), (class_2680)class_2246.field_10166.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)oppositeAxis), 2);
            }
        }

        private boolean isTouchingAir(class_1936 level, class_2338 position) {
            for (class_2350 direction : GenerationConstants.HORIZONTALS) {
                if (level.method_22347(position.method_10093(direction))) continue;
                return false;
            }
            return true;
        }

        private class_2680 getFenceState(class_1936 level, class_2338 position) {
            boolean east = level.method_8320(position.method_10078()).method_26204() == class_2246.field_10620;
            boolean west = level.method_8320(position.method_10067()).method_26204() == class_2246.field_10620;
            boolean north = level.method_8320(position.method_10095()).method_26204() == class_2246.field_10620;
            boolean south = level.method_8320(position.method_10072()).method_26204() == class_2246.field_10620;
            return (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2354.field_10907, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)class_2354.field_10903, (Comparable)Boolean.valueOf(west))).method_11657((class_2769)class_2354.field_10905, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)class_2354.field_10904, (Comparable)Boolean.valueOf(south));
        }

        private static void generateShell(class_5281 world, class_2338 origin, class_5819 random, int size) {
            int x = size + random.method_43048(2);
            int y = 12 + random.method_43048(2);
            int z = size + random.method_43048(2);
            float radius = (float)(x + y + z) * 0.333f + 0.5f;
            for (class_2338 position : class_2338.method_20437((class_2338)origin.method_10069(-x, -y, -z), (class_2338)origin.method_10069(x, y, z)).map(class_2338::method_10062).collect(Collectors.toSet())) {
                boolean isNotInDoorway;
                boolean doorwayX = position.method_10263() >= origin.method_10263() - 2 + random.method_43048(2) && position.method_10263() <= origin.method_10263() + 2 + random.method_43048(2);
                boolean doorwayZ = position.method_10260() >= origin.method_10260() - 2 + random.method_43048(2) && position.method_10260() <= origin.method_10260() + 2 + random.method_43048(2);
                boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && position.method_10264() > origin.method_10264() || position.method_10264() > origin.method_10264() + y - (3 + random.method_43048(2));
                if (!(position.method_10262((class_2382)origin) <= (double)(radius * radius))) continue;
                class_2680 state = world.method_8320(position);
                if (!(state.method_26204() instanceof class_4739) && state.method_26214((class_1922)world, position) >= 0.0f && isNotInDoorway) {
                    world.method_8652(position, class_2246.field_10340.method_9564(), 3);
                }
                if (position.method_10264() == origin.method_10264()) {
                    world.method_8652(position, class_2246.field_9989.method_9564(), 3);
                }
                if (position.method_10264() > origin.method_10264() - 1 || state.method_26225()) continue;
                world.method_8652(position, class_2246.field_10445.method_9564(), 3);
            }
        }
    }
}

